function AISMN_LeaveTown::OnEnter(%this, %data)
{
   %object = GetThisObject(%data);
   %object.noDeathProps = true;
   
   // Remove all task dialog
   echo("!*!*!*  Character in LeaveTown::OnEnter");
   %count = ClientGroup.getCount();
   for(%i = 0; %i < %count; %i++) {
      %client = ClientGroup.getObject(%i);
      commandToClient(%client, 'DestroyAllTaskDlg', %client.getGhostID(%object));
   }
   
   // Restore any lost happiness
   RestoreLostHappinessFromHome(%data);
   RestoreLostHappinessFromJob(%data);
   RestoreLostHappinessFromDrunk(%data);
   
   %data.DisableMonitors();
   
   slgUnemployObject(%object);
   slgUnhouseObject(%object);
   slgUnhideObject(%object);
   if (%object.getTeam() == $OST_PLAYER)
   {
      %object.setSkinName("default");
      %object.playVocal("LEV");
   }
   %object.setTeam(0);
   
   // stop running the effect
   StopEffect(%object, "combat");
   
   SetPathForMapEdge(%data);
   %object.playThread(0, "run");
}

function AISMN_LeaveTown::OnExit(%this, %data)
{
   %object = GetThisObject(%data);
   %object.playThread(0, "root");
}

//EXIT 0: ARRIVED OUT OF TOWN
function AISMN_LeaveTown::Update(%this, %data)
{
   if (IsFollowingPath(%data) == false)
   {
      ReturnValue(%data, 0);
      return;
   }
   
   %object = GetThisObject(%data);
   %object.playThread(0, "run");
   ReturnValue(%data, -1);
}
